#!/bin/bash -
#===============================================================================
#
#          FILE: updatePortalPreferencesLdapPort.sh
#
#         USAGE: ./updatePortalPreferencesLdapPort.sh
#
#   DESCRIPTION: Updates the LDAP port used to connect to LDAP for authentication.
#
#       OPTIONS: ---
#  REQUIREMENTS: ---
#          BUGS: ---
#         NOTES: ---
#        AUTHOR: EGBERT, BARRY
#  ORGANIZATION:
#       CREATED: 05/31/2018
#      REVISION:  1.0
#===============================================================================

# This logic ensure that the Oracle service is up and running before executing the update script.
output=$(echo "exit;" | sudo su - oracle -c "sqlplus LIFERAY_LDB/liferay_LDB@ORCL 2>&1" | grep -c "Connected to")
while [ $output -ne 1 ]; do
	sleep 5s
	output=$(echo "exit;" | sudo su - oracle -c "sqlplus LIFERAY_LDB/liferay_LDB@ORCL 2>&1" | grep -c "Connected to")
done

# Update the admin user.
sudo su - oracle -c "sqlplus LIFERAY_LDB/liferay_LDB@ORCL @/vagrant/sql/liferay/update_portal_preferences_ldap_port.sql >> /data/logs/update_portal_preferences_ldap_port.log"

